/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework;

import com.mojang.blaze3d.platform.InputConstants;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.sixik.sdmshoprework.SDMShopPaths;
import net.sixik.sdmshoprework.api.INBTSerializable;
import net.sixik.sdmshoprework.client.screen.legacy.LegacyShopScreen;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopScreen;
import net.sixik.sdmshoprework.common.config.Config;
import net.sixik.sdmshoprework.common.config.ConfigFile;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.theme.SDMThemes;
import net.sixik.sdmshoprework.common.theme.ShopStyle;
import net.sixik.sdmshoprework.common.theme.ShopTheme;

public class SDMShopClient {
    public static ClientShopData creator;
    public static final ResourceLocation OPEN_GUI;
    public static final String SDMSHOP_CATEGORY = "key.category.sdmshopr";
    public static final String KEY_NAME = "key.sdmshop.shopr";
    public static KeyMapping KEY_SHOP;

    public static ShopTheme getTheme() {
        ShopTheme tm = ((SDMThemes)((Object)Config.THEMES.get())).getTheme();
        if (Config.THEMES.get() == SDMThemes.CUSTOM) {
            tm = new ShopTheme(Color4I.fromString((String)((String)Config.BACKGROUND.get())), Color4I.fromString((String)((String)Config.SHADOW.get())), Color4I.fromString((String)((String)Config.REACT.get())), Color4I.fromString((String)((String)Config.STOKE.get())), Color4I.fromString((String)((String)Config.TEXTCOLOR.get())), Color4I.fromString((String)((String)Config.SELCETTABCOLOR.get())));
        }
        return tm;
    }

    public static void init() {
        ClientTickEvent.CLIENT_PRE.register(SDMShopClient::keyInput);
        ClientLifecycleEvent.CLIENT_SETUP.register(SDMShopClient::onClientSetup);
        CustomClickEvent.EVENT.register(SDMShopClient::customClick);
        if (!ConfigFile.CLIENT.disableKeyBind) {
            KeyMappingRegistry.register((KeyMapping)KEY_SHOP);
        }
    }

    public static void openGui(boolean isOpenCommand) {
        SDMShopClient.openGui((ShopStyle)((Object)Config.STYLE.get()), isOpenCommand);
    }

    public static void openGui(ShopStyle shopStyle, boolean isOpenCommand) {
        switch (shopStyle) {
            case LEGACY: {
                new LegacyShopScreen(isOpenCommand).openGui();
                break;
            }
            case MODERN: {
                new ModernShopScreen(isOpenCommand).openGui();
            }
        }
    }

    public static EventResult customClick(CustomClickEvent event) {
        if (ShopBase.CLIENT != null && event.id().equals((Object)OPEN_GUI) && !ConfigFile.CLIENT.disableKeyBind) {
            SDMShopClient.openGui((ShopStyle)((Object)Config.STYLE.get()), false);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public static void keyInput(Minecraft mc) {
        if (KEY_SHOP.m_90859_() && ShopBase.CLIENT != null && !ConfigFile.CLIENT.disableKeyBind) {
            SDMShopClient.openGui((ShopStyle)((Object)Config.STYLE.get()), false);
        }
    }

    public static void onClientSetup(Minecraft minecraft) {
        creator = new ClientShopData(SDMShopPaths.getFileClient());
        SNBTCompoundTag d1 = SNBT.read((Path)SDMShopPaths.getFileClient());
        if (d1 != null) {
            creator.deserializeNBT((CompoundTag)d1);
        }
    }

    static {
        OPEN_GUI = new ResourceLocation("sdmshoprework", "open_gui");
        KEY_SHOP = new KeyMapping(KEY_NAME, InputConstants.Type.KEYSYM, 79, SDMSHOP_CATEGORY);
    }

    public static class ClientShopData
    implements INBTSerializable<CompoundTag> {
        public Path path;
        public List<String> favoriteCreator = new ArrayList<String>();

        public ClientShopData(Path path) {
            this.path = path;
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ListTag tags = new ListTag();
            for (String s : this.favoriteCreator) {
                tags.add((Object)StringTag.m_129297_((String)s));
            }
            nbt.m_128365_("favoriteCreator", (Tag)tags);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.favoriteCreator.clear();
            ListTag tags = (ListTag)nbt.m_128423_("favoriteCreator");
            for (Tag tag : tags) {
                this.favoriteCreator.add(((StringTag)tag).m_7916_());
            }
        }
    }
}

